<?php  
/* 
Plugin Name: VC Sine Background
Version: 1.0
Author: Boom-Apps
Author URI: http://codecanyon.net/user/boom-apps
Description: Animated background for Visual Composer row
*/  

class VC_SineBackground {
	
	
	function backendElement() {
		vc_map( array(
            "name" => __("VC Sine Background", 'vc_extend'),
            "description" => __("Creative backgrounds!", 'vc_extend'),
            "base" => "vc_sinebackground",
            "class" => "",
            "controls" => "full",
			"custom_markup" => "<strong>VC Sine Background</strong><br /><a href='" . plugins_url() . "/vcsinebackground/_generator/index.html' target='_blank'>Settings generator</a>",
			"params" => array(
				  array("save_always" => true, "type" => "textarea", "holder" => "div", "class" => "", "heading" => "Id - unique per page", "param_name" => "theid", "value" => "vcwavesbackground_".time()."_".rand(100000,999999999) ),
				  array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Spacing", "param_name" => "spacing", "value" => "50", "description" => "spacing"),
				  array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Base size", "param_name" => "basesize", "value" => "25", "description" => "baseSize"),
				  array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Added size", "param_name" => "addedsize", "value" => "20", "description" => "addedSize"),
				  array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Multiplier X", "param_name" => "multx", "value" => "0.5", "description" => "multX"),
				  array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Multiplier Y", "param_name" => "multy", "value" => "0.9", "description" => "multY"),
				  array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Multiplier sum", "param_name" => "multsum", "value" => "0.1", "description" => "multSum"),
				  array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Tick speed", "param_name" => "tickspeed", "value" => "0.01", "description" => "tickSpeed"),
				  array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Hue tick speed", "param_name" => "huemult", "value" => "0", "description" => "hueMult"),
				  array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Saturation", "param_name" => "saturation", "value" => "100", "description" => "saturation"),
				  array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Lightness", "param_name" => "lightness", "value" => "65", "description" => "lightness"),
				  array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Opacity", "param_name" => "opacity", "value" => "1", "description" => "opacity"),
				  array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Base hue", "param_name" => "huefrom", "value" => "336", "description" => "hueFrom"),
				  array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Max gradient hue", "param_name" => "huemax", "value" => "51", "description" => "hueMax"),
				  array("save_always" => true, "type" => "dropdown", "class" => "", "heading" => "Shape", "param_name" => "shape", "value" => array("Circle" => "circle","Hexagon" => "hexagon","Triangle" => "triangle","Square" => "square"), "description" => "shape"),
			)
			
			
        ) );
		 
	}
	function theShortcode($Atts, $Content = null) {
		wp_enqueue_script(  array( 'jquery','hexagonizedwave','vc_sinebackground' ) );
		wp_enqueue_style(  array( 'vc_sinebackground' ) );
		
		$BgColor = self::convertColor($Atts['background']);
		$Atts['backgroundr'] = $BgColor[0];
		$Atts['backgroundg'] = $BgColor[1];
		$Atts['backgroundb'] = $BgColor[2];
		
		$Return = '<div id="'.$Atts['theid'].'" ';
		foreach ($Atts as $AttN => $AttV) {
			$Return .= 'data-'.str_replace("_","-",$AttN).'="'.$AttV.'" ';
		}
		$Return .= 'class="vc-sine-background" style="display:none;"></div>';
		
		return $Return;
	}
	
	
	function custom_css_classes_for_vc_row_and_vc_column( $class_string, $tag ) {
	  if ( $tag == 'vc_row' || $tag == 'vc_row_inner' ) {
		if (strpos($class_string,'boomapps_vcrow') == false) { $class_string = $class_string . " boomapps_vcrow"; } 
	  }
	  if ( $tag == 'vc_column' || $tag == 'vc_column_inner' ) {
		if (strpos($class_string,'boomapps_vccolumn') == false) { $class_string = $class_string . " boomapps_vccolumn"; }
	  }
	  return $class_string; 
	}
	
	
	function convertColor($hexStr, $returnAsString = false, $seperator = ',') {
		$hexStr = preg_replace("/[^0-9A-Fa-f]/", '', $hexStr); // Gets a proper hex string
		$rgbArray = array();
		if (strlen($hexStr) == 6) { //If a proper hex code, convert using bitwise operation. No overhead... faster
			$colorVal = hexdec($hexStr);
			$rgbArray['red'] = 0xFF & ($colorVal >> 0x10);
			$rgbArray['green'] = 0xFF & ($colorVal >> 0x8);
			$rgbArray['blue'] = 0xFF & $colorVal;
		} elseif (strlen($hexStr) == 3) { //if shorthand notation, need some string manipulations
			$rgbArray['red'] = hexdec(str_repeat(substr($hexStr, 0, 1), 2));
			$rgbArray['green'] = hexdec(str_repeat(substr($hexStr, 1, 1), 2));
			$rgbArray['blue'] = hexdec(str_repeat(substr($hexStr, 2, 1), 2));
		} else {
			return false; //Invalid hex color code
		}
		return $returnAsString ? implode($seperator, $rgbArray) : $rgbArray; // returns the rgb string or the associative array
	} 
	
	
	function registerStuff() {
		add_shortcode( 'vc_sinebackground', array($this,'theShortcode') );	
		$this->backendElement();		
	}
	function registerScripts() {
		 wp_register_script( 'vc_sinebackground', plugins_url('vcsinebackground.js',__FILE__ ) );
		 wp_register_style( 'vc_sinebackground', plugins_url('vcsinebackground.css',__FILE__ ) );
		 wp_register_script( 'hexagonizedwave', plugins_url('_3rdparty/hexagonizedwave.js',__FILE__ ) );
		
	}
	function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'registerScripts') );
		add_action( 'init', array( $this, 'registerStuff') );	
		add_filter( 'vc_shortcodes_css_class', array($this,'custom_css_classes_for_vc_row_and_vc_column'), 10, 2 );
	}
}


/* Let's go! */
if (function_exists('vc_map')) {
	new VC_SineBackground;
}

